/** @file   MCapturable.h
 * @brief   Declarations of MCapturable - iterface.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MCAPTURABLE_H
#define H_WWW_MCAPTURABLE_H



//
// Forward declarations
class GameObject;



namespace WeWantWar {


/** @class  MCapturable
 * @brief   Interface for the object who allow themselves being captured.
 * @author  Tomi Lamminsaari
 *
 * If object can be captured by another object, it must implement this
 * interface. There are certain rules the object must obey.
 *
 * First rule is that in the object's update() - method, you must check
 * if the vehicle is captured. If it is, you must use the controller of the
 * master object to receive correct controlling commands.
 *
 * Second rule is that the kill() - method must kill the master object if
 * he should get killed along with the captured object.
 */
class MCapturable
{
public:
  
  /** This method is called when an object captures this object.
   * @param   aMaster             Pointer to object who captured us. If this is
   *                              a nullpointer, then this object is released.
   */
  virtual void capture( GameObject* aMaster ) = 0;
  
  /** Resurrects the object. This is called by the game engine when our master
   * has been resurrected.
   */
  virtual void resurrect() = 0;

  /** Tells if this object can be captured at the moment.
   * @return  Can this object be captured at the moment.
   */
  virtual bool canBeCaptured() const = 0;
  
  /** Returns the pointer to object who has captured us.
   * @return  Pointer to our master object or null-pointer if we're not
   *          captured.
   */
  virtual GameObject* getMaster() const = 0;
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: MCapturable.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:01+02  lamminsa
 * Initial revision
 *
 */
 
